function RollFixedcEstimate(d, Prog);

%	Set output files
f1 = [Prog.OutputDir '\DrawList.lst'];
f2 = [Prog.OutputDir '\GibbsAnalyze.lst'];
if Prog.MakeDraws
	[s,w]=dos(['del "' f1 '"']);
	[s,w]=dos(['del "' f2 '"']);	%	If we're making fresh draws, delete any old gibbs analysis listings.
	[s,w]=dos(['del "' Prog.OutputDir '\*.fig"']);	%	Also delete any figure files.
	diary(f1);
else
	[s,w]=dos(['del "' f2 '"']);
	diary(f2);
end

%	Print header information
format compact;
disp(' ');
disp([Prog.RunDesc ' starting on ' datestr(now)]);
disp(Prog);

%	Compute transformations of input data.
Prog.ndays = length(d);
for i=1:Prog.ndays
	d(i).p = log(d(i).P);
	d(i).dp = diff(d(i).p);
	d(i).dP = diff(d(i).P);
end

%	Various summary statistics
disp(repmat('-',1,50));
StructStats(d,1);
disp(repmat('-',1,50));
RollParam_dp = RollEstimate(d,'dp');
disp(repmat('-',1,50));
RollParam_dP = RollEstimate(d,'dP');

par.varu = RollParam_dp.Variance;
if isfinite(RollParam_dp.HalfSpread)
	par.c = RollParam_dp.HalfSpread;
else
	par.c = .001;
end
for i=1:length(d)
	d(i).q = [1 diff(d(i).p)];
	d(i).m = log(exp(d(i).p) - .000001*d(i).q);
end

disp(repmat('-',1,50));
disp('Starting Values:');
disp(par);

%	Set Priors
Priors.c.mu = 0;
Priors.c.cov = 1000;
Priors.varu.alpha = 1e-12;
Priors.varu.beta = 1e-12;
disp(repmat('-',1,50));
disp('Priors');
StructDisp(Priors);

if Prog.MakeDraws
	Draws = Gibbs(Prog, d, par, Priors);
	save(['.\' Prog.OutputDir '\Draws'],'Draws');
else
	disp('Reading saved draws.');
	load(['.\' Prog.OutputDir '\Draws']);
end

AnalyzeGibbsDraws(Prog, Draws, d);
diary off;
return;

%**************************************************************************************

function Draws = Gibbs(Prog, d, par, Priors)

tic;
dp = [d.dp];

disp(repmat('-',1,50));
disp([Prog.RunDesc ' Draw. . .']);
for iDraw=1:Prog.nDraw
	
	npr = 100;	% Print a message every npr draws.
	%npr = 1;
	if (mod(iDraw,npr)==0) fprintf(1,'%6d',iDraw); end;
	if (mod(iDraw,10*npr)==0 | iDraw==Prog.nDraw) fprintf(1,'\n'); end;
	
	if Prog.Draw_q
		newd=RollFixedDraw(d,par);
		for i=1:length(d)
			d(i).m = newd(i).m;
			d(i).q = newd(i).q;
		end
	else
		for i=1:length(d);
			d(i).m = d(i).p - par.c*d(i).q;
		end
	end
	for i=1:length(d); d(i).dq = diff(d(i).q); end;
	dq = [d.dq];
	
	Posterior = BayesRegressionUpdate(Priors.c, dp.', dq.', par.varu);
	New_c = RandNormT(Posterior.mu, sqrt(Posterior.cov), 0, inf);
	
	for i=1:length(d); d(i).u = d(i).dp - New_c*d(i).dq;	end;
	u = [d.u];
	
	Posterior = BayesVarianceUpdate(Priors.varu, u);
	New_varu = InverseGammaRnd(Posterior.alpha, Posterior.beta);
	
	par.varu = New_varu;
	par.c = New_c;
	
	CurrDraw.par = par;
	
	if Prog.OtherDiagnostics
		CurrDraw.uqCorr = uqCorr(d);
		names = {'u', 'q'};
		[acv,ac] = AutoCrossD(d,names,1);
		CurrDraw.ac0 = ac(:,:,1);
		CurrDraw.ac1 = ac(:,:,2);
% 		c = diag([1 par.c]);
% 		CurrDraw.acvdpComps = c*acv(:,:,2)*c;
% 		CurrDraw.acvdpSum = sum(sum(CurrDraw.acvdpComps));
	end
	
	if iDraw==1
		Draws = repmat(CurrDraw, Prog.nDraw, 1);	%	Allocate entire array on first draw.
	else
		Draws(iDraw) = CurrDraw;
	end
	
end	%	End of iDraw loop.

ElapsedTime = toc;
disp(['Elapsed time: ' num2str(ElapsedTime) ' seconds  (' shms(ElapsedTime) ').']);

return

%**************************************************************************************

function AnalyzeGibbsDraws(Prog, Draws, d);

[D,DNames] = DrawStructure2Matrix(Draws);
GibbsSummary(D,.2,DNames);

sdu = 10000*sqrt(GetDrawVector(Draws,'par.varu'));
c = GetDrawVector(Draws,'par.c');
PAvg = mean([d.P]);
C=(exp(c)-1)*PAvg;
c = 10000*c;	%rescale

GibbsSummary([sdu c C], .2, {'sd_u x 10,000' 'c x 10,000' 'C'});

if Prog.GibbsGraphs
	fn={'\sigma_{\itu}\times10,000' '\itc\times10,000' '\itC (ticks)'};
	GibbsGraphs([sdu c C],.1,100,fn);
	saveas(gcf,  [Prog.OutputDir '\graph.fig']);
	figure;
	%fn={'\it\sigma_{u}' '\itc' '\itC'};
	GibbsGraphsPost([sdu c C],.1,fn);
	saveas(gcf,  [Prog.OutputDir '\post.fig']);
end

%**************************************************************************************

function newd=RollFixedDraw(d,par)
for i=1:length(d)
	ranu = rand(1,length(d(i).p));	%	Draw all of the random numbers needed.
	
	%	RollFixedc_mq is coded in C++ and compiled using the mex function.
% 	newd(i) = RollFixedc_mq(d(i),ranu,par);
	
	%	RollFixedc_mqMatlab is an equivalent routine, written entirely in matlab.
	%	It is slower than the C++ version by about a factor of ten.
	newd(i) = RollFixedc_mqMatlab(d(i),ranu,par);
end

%**************************************************************************************

function dNew = RollFixedc_mqMatlab(d,ranu,par)
error('oops')
varu = par.varu;
c = par.c;
m = d.m;
p = d.p;
q = zeros(1,length(m));
T = length(m);
for t=1:T	%	This loop is the killer.
	if t==1
		mu = m(2);
		var = varu;
	elseif t==T
		mu = m(T-1);
		var = varu;
	else
		mu = (m(t-1)+m(t+1))/2.;
		var = varu/2.;
	end
	f = p(t)+c-mu;
	PSell = exp(-f*f/(2*var));
	f = p(t)-c-mu;
	PBuy = exp(-f*f/(2*var));
	PBuy = PBuy/(PBuy+PSell);
	q(t) = 1.;
	if (ranu(t)>PBuy); q(t)=-1.; end;
	m(t) = p(t) - q(t)*c;
end
dNew = d;
dNew.m = m;
dNew.q = q;
return